/*----------------------------------------------------------------------------
 *  Organization:  Copyright © 2021 NST, LTD. all rights reserved.
 *----------------------------------------------------------------------------*/

#include "common_function.h"

// Enable WANNA_USE_OPENCV define in CMakelist.txt
#ifdef WANNA_USE_OPENCV
    #include "opencv2/opencv.hpp"
    using namespace cv;
    using namespace std;
#endif // WANNA_USE_OPENCV

#define video_frame_width  1280
#define video_frame_height 720

int32_t main(int32_t argc, char** argv)
{
    printf("The version of SDK is %s\n", moGetSdkVersion());

    MO_CAMERA_HANDLE hCameraHandle = MO_INVALID_HANDLE;

    BEGIN_TO_WORK(argc, argv[1])

    /**< 1. Open specific camera */
    s32Result = moOpenUVCCameraByPath(caCameraPath, &hCameraHandle);
    BREAK_INFO_PRINT(s32Result, moOpenUVCCameraByPath)

    uint64_t      u64ImageFrameNum = 0;
    uint8_t*      pu8FrameBuffer   = NULL;
    uint8_t*      pu8LeftBayerImg  = NULL;
    uint8_t*      pu8RightBayerImg = NULL;
    double        d8FPS            = 0.0f;
    char          caFPS[24]        = {0};
    mo_video_mode eVideoMode       = MVM_RAW;

    /**< 2. get current video mode */
    s32Result = moGetVideoMode(hCameraHandle, &eVideoMode);
    BREAK_INFO_PRINT(s32Result, moGetVideoMode)

    /**< 3. set RAW mode : frame = Bayer + Bayer */
    if (MVM_RAW != eVideoMode) {
        s32Result = moSetVideoMode(hCameraHandle, MVM_RAW);
        BREAK_INFO_PRINT(s32Result, moSetVideoMode)
    }

    BEGIN_GET_VIDEO_FRAME_LOOP

    /**< 4. get current video frame */
    s32Result = moGetCurrentFrame(hCameraHandle, &u64ImageFrameNum, &pu8FrameBuffer);
    BREAK_INFO_PRINT(s32Result, moGetCurrentFrame)

    /**< 5. get real-time FPS */
    s32Result = moGetRealTimeFPS(hCameraHandle, &d8FPS);

    // Failed to get FPS(usually caused by insufficient frame counts during initial period)
    if (0 != s32Result) {
        printf("moGetRealTimeFPS fails, return %d\n", s32Result);
        strcpy(caFPS, "FPS: being counted");
        printf("FN: %lu FB: %p %s\n", u64ImageFrameNum, pu8FrameBuffer, caFPS);
    } else {
        sprintf(caFPS, "FPS: %f", d8FPS);
        printf("FN: %lu FB: %p %s\n", u64ImageFrameNum, pu8FrameBuffer, caFPS);
    }

    /**< 6. get left and right image */
    s32Result = moGetRawImage(hCameraHandle, pu8FrameBuffer, &pu8LeftBayerImg, &pu8RightBayerImg);
    BREAK_INFO_PRINT(s32Result, moGetRawImage)

    #ifdef WANNA_USE_OPENCV
    waitKey(FETCH_AND_DISPLAY_TIME_LENGTH);
    Mat matLeftBGR;
    Mat matLeftBayer(video_frame_height, video_frame_width, CV_16UC1, pu8LeftBayerImg);
    cvtColor(matLeftBayer, matLeftBGR, COLOR_BayerGB2BGR_EA);
    // Mark fps at top left corner
    putText(matLeftBGR, string(caFPS), Point(50, 60), FONT_HERSHEY_COMPLEX, 1, Scalar(255 * 255, 0, 0));
    imshow("LeftBayer", matLeftBGR);

    Mat matRightBGR;
    Mat matRightBayer(video_frame_height, video_frame_width, CV_16UC1, pu8RightBayerImg);
    cvtColor(matRightBayer, matRightBGR, COLOR_BayerGB2BGR_EA);
    // Mark fps at top left corner
    putText(matRightBGR, string(caFPS), Point(50, 60), FONT_HERSHEY_COMPLEX, 1, Scalar(255 * 255, 0, 0));
    imshow("RightBayer", matRightBGR);
    #endif // WANNA_USE_OPENCV

    END_GET_VIDEO_FRAME_LOOP
    END_TO_WORK

    /**< 7. Close specific camera */
    moCloseCamera(&hCameraHandle);

    return s32Result;
}
